### 1. Cloud as an Extension of On-Premise Networks

- Cloud networks extend, not replace, on-premise networks.
- Physical devices (e.g., mobile devices) always involved in accessing cloud resources.
- 100% cloud environments are not realistic due to hardware requirements.

---
### 2. Physical Security in the Cloud

#### **Provider Responsibilities**

- Providers enforce strong physical security in data centers:
    - Biometric controls (retina/hand scanners)
    - Electro-magnetic locks, keycards, armed guards

#### **Your Responsibilities**

- Do not ignore your role in securing the cloud environment.
- Shared responsibility model: provider and consumer must both secure the environment.

---

### 3. Authentication Methods

- **What you know**: Passwords, PINs
- **What you have**: Physical tokens, cards
- **What you are**: Biometrics (fingerprint, retina)
- Biometrics are strongest but challenging to use remotely in public cloud.
- Multi-factor authentication (MFA) combines these methods for enhanced security.

---

### 4. Endpoint and Access Security

- Protect physical devices (endpoints) that access cloud infrastructure.
- Risks:
    - Credentials saved in browsers can be stolen if endpoint is physically compromised.
    - Internet kiosks and public computers are high risk.
    - Lost/stolen mobile devices may compromise cloud security.
- Use MDM/EMM solutions (e.g., Cisco Meraki) to secure mobile devices.

---

### 5. Data Circuits and Network Security

- Data circuits (especially in multi-tenant buildings) are targets for network taps and interception.
- Protect physical and virtual network infrastructure.

---

### 6. Cisco SAFE Design Methodology

- **Cisco SAFE Concepts:**
    - **Places in the Network (PINs):** Cloud, network edge, data center, campus, branch, WAN, public internet.
    - **Secure Domains:** Management, security intelligence, compliance, segmentation, threat defense, secure services.
- Each secure domain requires unique implementation depending on the PIN.
- SAFE helps ensure every aspect of the network performs its security role.

---

### 7. Cloud Management and Visibility

- Plan how to manage the cloud: scripts, APIs, tools, personnel, approval processes.
- Ensure visibility for proactive threat detection and response.
- Support for features like Active/Standby appliances and quick response capabilities is important.

---

### 8. Compliance and Segmentation

- Compliance includes meeting external and internal audit requirements.
- Segmentation should be treated independently:
    - Granularity (user groups, applications, geography)
    - Different access for different users or regions

---

### 9. Threat Detection, Response, and Defense

- Visibility and defense are tightly integrated.
- Must be able to recognize and mitigate threats quickly.
- Use native cloud tools (flow logs, audit reports) and API-based tools for unified visibility across environments.

---

### 10. Securing All Components and Connections

- Cloud security, endpoint security, and the network in-between must all be protected.
- Firewalls, IDS/IPS, routers, switches, and load balancers provide control and visibility.

---

### 11. Cloud Access Security Broker (CASB)

- CASB solutions protect:
    - Cloud applications
    - User accounts and data
    - Prevents sensitive data from being uploaded externally

---

### 12. Cloud Orchestration Tools

- Two main use cases:
    - Application lifecycle management
    - Governance (enforcing usage metrics and access control)
- Automate deployment, scaling, decommissioning, and enforce policies.

---

**Key Takeaways:**

- Cloud environments are part of your broader network and require physical, logical, and procedural security.
- Shared responsibility between provider and consumer.
- Use layered and multifactor security, protect endpoints, and ensure network visibility and segmentation.
- Cisco SAFE provides a framework for comprehensive security across all environments.